#pragma once

#include "global.h"
#include "d3d.h"

class Texture
{
public:
	Texture();
	Texture(const string &szFilename);
	~Texture();

	/**
	 * Do functions
	 */
	bool Create(const string &szFilename);
	bool Create(dword width, dword height);
	void Destroy();

	bool IsLoaded();

	bool Render();
	bool Render(int x, int y);
	bool Render(int x, int y, dword w, dword h);

	/**
	 * Set functions
	 */
	void SetOpacity(byte opacity);
	void SetTint(byte r, byte g, byte b);

	void MoveTo(int x, int y);

	/**
	 * Get functions
	 */
	dword GetWidth();
	dword GetHeight();

	byte GetOpacity();

	D3DTexture *GetTexture();

private:
	/**
	 * A d3d texture object that will contain the loaded texture
	 * and a d3d vertex buffer object that will contain the vertex
	 * buffer for the quad which will display the texture
	 */
	D3DTexture *m_pTexture;
	D3DVertexBuffer *m_pVertexBuffer;

	/**
	 * The default render position of the texture
	 */
	int m_x, m_y;

	/**
	 * The width and height of the texture
	 */
	D3DXIMAGE_INFO m_imageInfo;

	/**
	 * The opacity of the texture
	 */
	byte m_byOpacity;
	byte m_byR, m_byG, m_byB;

	/**
	 * Whether the texture has been created or not
	 */
	bool m_bLoaded;
};
